#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Exploding MandelbrotMod01.fsh  by  Chris_M_Thomasson
//https://www.shadertoy.com/view/XtscDl
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Very nice coloring, zoom and anti-aliasing by:

// inigo quilez - iq/2013
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.


// See here for more information on smooth iteration count:
//
// https://iquilezles.org/articles/msetsmooth


// Exploding Pulsing Mandelbrot Set by Chris M. Thomasson
// Orbit trap color by Chris M. Thomasson
// http://www.fractalforums.com/index.php?action=gallery;sa=view;id=20582

vec2 ct_cmul(in vec2 p0, in vec2 p1)
{
    return vec2(p0.x * p1.x - p0.y * p1.y, p0.x * p1.y + p0.y * p1.x);
}


// increase this if you have a very fast GPU
#define AA 2

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec3 col = vec3(0.0);
    
#if AA>1
    for( int m=0; m<AA; m++ )
    for( int n=0; n<AA; n++ )
    {
        vec2 p = (-iResolution.xy + 2.0*(fragCoord.xy+vec2(float(m),float(n))/float(AA)))/iResolution.y;
        float w = float(AA*m+n);
        float time = iTime + 0.5*(1.0/24.0)*w/float(AA*AA);
#else    
        vec2 p = (-iResolution.xy + 2.0*fragCoord.xy)/iResolution.y;
        float time = iTime;
#endif
    
        float zoo = 1.0 + 0.38*cos(.07*time);
        float coa = cos( 0.15*(1.0-zoo)*time );
        float sia = sin( 0.15*(1.0-zoo)*time );
        zoo = pow( zoo,8.0);
        vec2 xy = vec2( p.x*coa-p.y*sia, p.x*sia+p.y*coa);
        vec2 c = vec2(-.745,.186) + xy*zoo;

        float B = 200.0;// + abs(cos(iTime * .25)) * 30.0;
        float l = 0.0;
        float ct_o = 999999999.0;
	    vec2 z  = vec2(0.0);
        int ct_retry = 0;
        int ct_switch = 0;
        for( int i=0; i<256; i++ )
        {
            // z = z*z + c		
    		z = vec2( z.x*z.x - z.y*z.y * (1.0 + abs(cos(iTime * 2.0)) * .1), (2.0 + abs(sin(iTime * 3.0)) * .1)*z.x*z.y ) + c;
            ct_o = min(ct_o, sqrt(z.x * z.x + z.y * z.y));
		
    		if(z.x * z.x + z.y * z.y > B)
            {
                // Chris M. Thomassons Exploder!
                if (ct_retry < 7)
                {
                    if (ct_switch == 0)
                    {
                        z = ct_cmul(z, vec2(.02 + abs(cos(iTime * .5)) * .02, .07));
                        ct_switch = 1;
                    }
                    
                    else
                    {
                        z = ct_cmul(z, vec2(-.04, -(.04 + abs(sin(iTime)) * .041)));
                        ct_switch = 0;
                    }
                    
                	++ct_retry;
                	continue;
                }
                break;
            }

    		l += 1.0;
        }

    	// ------------------------------------------------------
        // smooth interation count
    	//float sl = l - log(log(length(z))/log(B))/log(2.0);
        
        // equivalent optimized smooth interation count
    	float sl = l - log2(log2(dot(z,z))) + 4.0; 
    	// ------------------------------------------------------
	
        float al = smoothstep( -5.0, 0.0, cos(3.14*iTime) );
        l = mix( l, sl, al );

        // CT: added some color wrt ct_o variable.
        col += 0.5 + 0.5*cos( 3.0 + l*0.15 + vec3(.5 + cos(3.14*iTime) * .5, ct_o * l * .05, 0));
#if AA>1
    }
    col /= float(AA*AA);
#endif

    fragColor = vec4( col, 1.0 );
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

